/*
 * Decompiled with CFR 0.152.
 */
package ru.pixelmongo.updater;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import ru.pixelmongo.updater.Main;

public class Error {
    public static Font FONT = new Font("Verdana", 0, 13);
    private static boolean isSystemLaf = false;

    public static void load() {
        try {
            Error.class.getClassLoader().loadClass(Frame.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static void show(String title, String ... msg) {
        Error.setLAF();
        new Frame(title, Error.implode(msg)).setVisible(true);
    }

    public static void show(String title, Throwable th, String ... msg) {
        Error.setLAF();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        th.printStackTrace(pw);
        String header = msg.length == 0 ? "\n      \u0427\u0442\u043e-\u0442\u043e \u043f\u043e\u0448\u043b\u043e \u043d\u0435 \u0442\u0430\u043a...\n" : Error.implode(msg);
        new Frame(title, String.valueOf(header) + "\n\n\n\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u0434\u043b\u044f \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u043e\u0432:\n\n" + sw.toString()).setVisible(true);
    }

    private static String implode(String ... msg) {
        StringBuilder sb = new StringBuilder();
        String[] arr$ = msg;
        int len$ = msg.length;
        int i$ = 0;
        while (i$ < len$) {
            String s = arr$[i$];
            sb.append(s).append("\n");
            ++i$;
        }
        return sb.toString();
    }

    private static void setLAF() {
        if (!isSystemLaf) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            isSystemLaf = true;
        }
    }

    private static class Frame
    extends JFrame {
        public Frame(String title, String message) {
            super(title);
            this.setDefaultCloseOperation(3);
            this.getRootPane().setLayout(new BorderLayout());
            this.setSize(800, 480);
            this.setLocationRelativeTo(null);
            if (Main.iconImages.size() > 0) {
                this.setIconImages(Main.iconImages);
            }
            JTextArea text = new JTextArea();
            text.setTabSize(2);
            text.setEditable(false);
            text.setText(message);
            text.setFont(FONT);
            text.setWrapStyleWord(true);
            text.setLineWrap(true);
            JScrollPane scroll = new JScrollPane(text);
            this.getRootPane().add((Component)scroll, "Center");
        }
    }
}

