/*
 * Decompiled with CFR 0.152.
 */
package ru.pixelmongo.updater;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import ru.pixelmongo.updater.CdnFile;
import ru.pixelmongo.updater.Error;
import ru.pixelmongo.updater.ExtendedProgressBarUI;
import ru.pixelmongo.updater.LogoPanel;
import ru.pixelmongo.updater.UpdaterConfig;
import ru.pixelmongo.updater.UpdaterResponse;
import ru.pixelmongo.updater.Util;
import ru.pixelmongo.updater.json.Json;
import ru.pixelmongo.updater.util.MD5;

public class Main
extends JFrame {
    private static final long serialVersionUID = 6050243704896603246L;
    private static JPanel Logo;
    private static JProgressBar progress;
    private static List<CdnFile> UpdateList;
    public static Throwable lastThrowable;
    public static UpdaterResponse updaterResponse;
    public static boolean trustAll;
    public static List<Image> iconImages;

    static {
        int[] sizes;
        Logo = new LogoPanel();
        progress = new JProgressBar();
        UpdateList = new ArrayList<CdnFile>();
        updaterResponse = null;
        trustAll = false;
        iconImages = new ArrayList<Image>();
        int[] nArray = sizes = new int[]{256, 128, 64, 48, 32, 24, 16};
        int n = sizes.length;
        int n2 = 0;
        while (n2 < n) {
            int sz = nArray[n2];
            try {
                URL url = Main.class.getResource("/ru/pixelmongo/updater/icons/icon-" + sz + ".png");
                BufferedImage image = ImageIO.read(url);
                iconImages.add(image);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public Main() {
        this.setUndecorated(true);
        this.setTitle(UpdaterConfig.titleUpdater);
        this.setSize(480, 333);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setBackground(new Color(0, 0, 0, 0));
        if (iconImages.size() > 0) {
            this.setIconImages(iconImages);
        }
        progress.setUI(new ExtendedProgressBarUI(new Color(59, 17, 91)));
        progress.setForeground(new Color(54, 246, 253));
        progress.setBorder(new EmptyBorder(3, 3, 3, 3));
        progress.setBorderPainted(true);
        progress.setMaximum(0);
        progress.setMinimum(0);
        progress.setValue(0);
        this.add((Component)Logo, "Center");
        progress.setBounds(48, 228, 380, 28);
        progress.setOpaque(false);
        Logo.add(progress);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        System.out.println("FORCING EXIT!");
                        System.exit(0);
                    }
                }.start();
                System.exit(0);
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        super.paintComponents(g);
    }

    private static void MKDir(String add) {
        try {
            if (add.length() > 1) {
                while (!add.endsWith("/")) {
                    add = add.substring(0, add.length() - 1);
                }
                File f = new File(Util.getWorkingDirectory(UpdaterConfig.launcherFolder), add);
                f.mkdirs();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void StartLauncher() {
        try {
            System.out.println("Running Launcher");
            File pathToJar = new File(Util.getWorkingDirectory(UpdaterConfig.launcherFolder), Main.updaterResponse.launcher.file);
            List<Object> params = new ArrayList();
            if (Main.updaterResponse.launcher.args != null) {
                params = Main.updaterResponse.launcher.args;
            }
            ArrayList<URL> var5 = new ArrayList<URL>();
            var5.add(pathToJar.toURI().toURL());
            URLClassLoader loader = new URLClassLoader(var5.toArray(new URL[var5.size()]));
            Class<?> start = loader.loadClass(Main.updaterResponse.launcher.mainClass);
            Method main = start.getMethod("main", String[].class);
            main.invoke(null, new Object[]{params.toArray(new String[0])});
        }
        catch (Throwable localException) {
            localException.printStackTrace();
            Error.load();
            Error.show("PixelmonGo Updater Error", localException, new String[0]);
        }
    }

    public static boolean updateFiles() {
        int j = 0;
        while (j < 3) {
            try {
                if (UpdateList.size() == 0) {
                    progress.setValue(1);
                    progress.setMaximum(1);
                } else {
                    progress.setValue(0);
                    int sumSize = 0;
                    for (CdnFile cdnFile : UpdateList) {
                        sumSize += cdnFile.size;
                    }
                    progress.setMaximum(sumSize);
                }
                for (CdnFile s : UpdateList) {
                    int bufferSize;
                    Main.MKDir(s.path);
                    System.out.println("DOWNLOAD: " + s.path);
                    URLConnection urlconnection = null;
                    URL url0 = new URL(s.url);
                    int i = 0;
                    block13: while (i < 3) {
                        urlconnection = (HttpURLConnection)url0.openConnection();
                        if (trustAll && urlconnection instanceof HttpsURLConnection) {
                            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                                @Override
                                public X509Certificate[] getAcceptedIssuers() {
                                    return new X509Certificate[0];
                                }

                                @Override
                                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                                }

                                @Override
                                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                                }
                            }};
                            HostnameVerifier ALL_TRUSTING_HOSTNAME_VERIFIER = new HostnameVerifier(){

                                @Override
                                public boolean verify(String hostname, SSLSession session) {
                                    return true;
                                }
                            };
                            try {
                                SSLContext sc = SSLContext.getInstance("SSL");
                                sc.init(null, trustAllCerts, new SecureRandom());
                                ((HttpsURLConnection)urlconnection).setSSLSocketFactory(sc.getSocketFactory());
                                ((HttpsURLConnection)urlconnection).setHostnameVerifier(ALL_TRUSTING_HOSTNAME_VERIFIER);
                            }
                            catch (GeneralSecurityException e) {
                                e.printStackTrace();
                            }
                        }
                        urlconnection.setConnectTimeout(48000);
                        urlconnection.setRequestProperty("Accept-Charset", "UTF-8");
                        urlconnection.setRequestProperty("User-Agent", "PixelmonGo Updater");
                        switch (((HttpURLConnection)urlconnection).getResponseCode()) {
                            case 301: 
                            case 302: {
                                url0 = new URL(url0, urlconnection.getHeaderField("Location"));
                                ((HttpURLConnection)urlconnection).disconnect();
                                ++i;
                                break;
                            }
                            default: {
                                break block13;
                            }
                        }
                    }
                    InputStream inputstream = urlconnection.getInputStream();
                    FileOutputStream fos = new FileOutputStream(new File(Util.getWorkingDirectory(UpdaterConfig.launcherFolder), s.path));
                    byte[] buffer = new byte[65536];
                    while ((bufferSize = inputstream.read(buffer, 0, buffer.length)) != -1) {
                        fos.write(buffer, 0, bufferSize);
                        progress.setValue(progress.getValue() + bufferSize);
                    }
                    ((HttpURLConnection)urlconnection).disconnect();
                    inputstream.close();
                    fos.close();
                }
                return true;
            }
            catch (SSLHandshakeException certificateException) {
                lastThrowable = certificateException;
                certificateException.printStackTrace();
                trustAll = true;
            }
            catch (Exception e) {
                lastThrowable = e;
                progress.setForeground(Color.RED);
            }
            if (j != 2) {
                try {
                    Thread.sleep(j * 4848);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            ++j;
        }
        return false;
    }

    public static boolean checkFiles() {
        UpdateList.clear();
        try {
            List<CdnFile> fileArrayList = Main.updaterResponse.files;
            progress.setValue(0);
            progress.setMaximum(fileArrayList.size());
            for (CdnFile cdnFile : fileArrayList) {
                if (!cdnFile.md5.toLowerCase().equals(Util.getMd5(cdnFile.path).toLowerCase())) {
                    UpdateList.add(cdnFile);
                }
                progress.setValue(progress.getValue() + 1);
            }
            return true;
        }
        catch (Exception e) {
            progress.setForeground(Color.RED);
            return false;
        }
    }

    public static boolean getConfig() {
        try {
            updaterResponse = new UpdaterResponse(Json.parse(Util.getHttpContent(String.valueOf(UpdaterConfig.https ? "https://" : "http://") + UpdaterConfig.downloadList + "?version=" + UpdaterConfig.version, trustAll)).asObject());
            return true;
        }
        catch (SSLHandshakeException certificateException) {
            lastThrowable = certificateException;
            certificateException.printStackTrace();
            trustAll = true;
        }
        catch (Throwable e) {
            lastThrowable = e;
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isUpdateUpdater() {
        block16: {
            CdnFile cdnFile;
            File self;
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    UpdateList.clear();
                                    if (UpdaterConfig.version == Main.updaterResponse.updater.version) break block16;
                                    self = Util.getSelf();
                                    if (self.exists()) break block17;
                                    Main.errorUpdate(24);
                                    return true;
                                }
                                if (!self.isDirectory()) break block18;
                                Main.errorUpdate(48);
                                return true;
                            }
                            cdnFile = null;
                            if (self.toString().toLowerCase().endsWith(".jar")) {
                                cdnFile = Main.updaterResponse.updater.jar;
                            }
                            if (self.toString().toLowerCase().endsWith(".exe")) {
                                cdnFile = Main.updaterResponse.updater.exe;
                            }
                            if (cdnFile != null) break block19;
                            Main.errorUpdate(37);
                            return true;
                        }
                        if (!cdnFile.md5.toLowerCase().equals(MD5.asHex(MD5.getHash(self)).toLowerCase())) break block20;
                        return false;
                    }
                    progress.setValue(0);
                    progress.setMaximum(1);
                    progress.setForeground(Color.ORANGE);
                    if (!cdnFile.md5.toLowerCase().equals(Util.getMd5(cdnFile.path).toLowerCase())) {
                        UpdateList.add(cdnFile);
                    }
                    progress.setValue(1);
                    if (Main.updateFiles()) break block21;
                    Main.errorUpdate(13);
                    return true;
                }
                if (cdnFile.md5.toLowerCase().equals(Util.getMd5(cdnFile.path).toLowerCase())) break block22;
                Main.errorUpdate(4848);
                return true;
            }
            try {
                ClassLoader classLoader = Main.class.getClassLoader();
                Util.loadAllClassesFromJar();
                if (classLoader instanceof Closeable) {
                    ((Closeable)((Object)classLoader)).close();
                }
                File in = new File(Util.getWorkingDirectory(UpdaterConfig.launcherFolder), cdnFile.path);
                InputStream is = null;
                OutputStream os = null;
                try {
                    int length;
                    is = new FileInputStream(in);
                    os = new FileOutputStream(self);
                    byte[] buffer = new byte[1024];
                    while ((length = is.read(buffer)) > 0) {
                        os.write(buffer, 0, length);
                    }
                }
                finally {
                    is.close();
                    os.close();
                }
                in.delete();
                ArrayList<String> params = new ArrayList<String>();
                params.add(String.valueOf(System.getProperty("java.home")) + "/bin/java");
                params.add("-jar");
                params.add(self.toString());
                ProcessBuilder pb = new ProcessBuilder(params);
                pb.start();
                return true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return false;
    }

    public static void errorUpdate(int code) {
        switch (code) {
            case 13: 
            case 4848: {
                JOptionPane.showMessageDialog(null, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0437\u0430\u043f\u0443\u0441\u043a\u0430\u0442\u043e\u0440 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430 (\u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438: " + code + ")\n\u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0435\u0449\u0435 \u0440\u0430\u0437 \u0438\u043b\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043d\u043e\u0432\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e \u0441 \u0441\u0430\u0439\u0442\u0430.", "PixelmonGo Updater Error", 0);
                break;
            }
            default: {
                JOptionPane.showMessageDialog(null, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0437\u0430\u043f\u0443\u0441\u043a\u0430\u0442\u043e\u0440 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430 (\u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438: " + code + ")\n\u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0444\u0430\u0439\u043b \u043a\u0443\u0434\u0430-\u043d\u0438\u0431\u0443\u0434\u044c \u0432 \u0434\u0440\u0443\u0433\u043e\u0435 \u043c\u0435\u0441\u0442\u043e \u0438 \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0435\u0449\u0435 \u0440\u0430\u0437 \u0438\u043b\u0438 \u0441\u043a\u0430\u0447\u0430\u0442\u044c \u043d\u043e\u0432\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e \u0441 \u0441\u0430\u0439\u0442\u0430.", "PixelmonGo Updater Error", 0);
            }
        }
    }

    public static void main(String[] var0) {
        System.setProperty("java.net.preferIPv4Stack", "true");
        new Main();
        try {
            int i = 0;
            while (i < 3) {
                if (Main.getConfig()) break;
                if (i != 2) {
                    Thread.sleep(i * 4848);
                }
                ++i;
            }
            if (updaterResponse == null) {
                UpdaterConfig.https = !UpdaterConfig.https;
                i = 0;
                while (i < 3) {
                    if (Main.getConfig()) break;
                    if (i != 2) {
                        Thread.sleep(i * 4848);
                    }
                    ++i;
                }
            }
            if (updaterResponse == null) {
                Error.load();
                Error.show("PixelmonGo Updater Error", lastThrowable, "      \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043a \u0438\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u0443. \u0415\u0441\u043b\u0438 \u0438\u043d\u0442\u0435\u0440\u043d\u0435\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442 \u0445\u043e\u0440\u043e\u0448\u043e, \u0437\u043d\u0430\u0447\u0438\u0442 \u0432\u044b\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0430\u043d\u0442\u0438\u0432\u0438\u0440\u0443\u0441 \u0438 \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043b\u0430\u0443\u043d\u0447\u0435\u0440 \u0441\u043d\u043e\u0432\u0430.");
                return;
            }
            if (Main.isUpdateUpdater()) {
                Thread.sleep(480L);
                System.exit(-1);
                return;
            }
            if (!Main.checkFiles()) {
                Error.load();
                Error.show("PixelmonGo Updater Error", lastThrowable, new String[0]);
                return;
            }
            if (!Main.updateFiles()) {
                Error.load();
                Error.show("PixelmonGo Updater Error", lastThrowable, new String[0]);
                return;
            }
            Main.StartLauncher();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

