/*
 * Decompiled with CFR 0.152.
 */
package ru.pixelmongo.updater;

import java.util.ArrayList;
import java.util.List;
import ru.pixelmongo.updater.CdnFile;
import ru.pixelmongo.updater.UpdaterConfig;
import ru.pixelmongo.updater.json.JsonArray;
import ru.pixelmongo.updater.json.JsonObject;
import ru.pixelmongo.updater.json.JsonValue;

public class UpdaterResponse {
    public Updater updater;
    public List<CdnFile> files;
    public Launcher launcher;

    public UpdaterResponse(JsonObject json) {
        this.updater = new Updater(json.get("updater").asObject());
        this.files = UpdaterResponse.readFilesList(json.get("files").asArray());
        this.launcher = new Launcher(json.get("launcher").asObject());
    }

    private static List<CdnFile> readFilesList(JsonArray arr) {
        ArrayList<CdnFile> files = new ArrayList<CdnFile>();
        for (JsonValue val : arr) {
            if (!val.isObject()) continue;
            files.add(new CdnFile(val.asObject()));
        }
        return files;
    }

    private static List<String> readArgsList(JsonArray arr) {
        ArrayList<String> args = new ArrayList<String>();
        for (JsonValue val : arr) {
            if (!val.isString()) continue;
            args.add(val.asString());
        }
        return args;
    }

    public static class Launcher {
        public String file;
        public String mainClass;
        public List<String> args;

        public Launcher(JsonObject json) {
            this.file = json.getString("path", null);
            this.mainClass = json.getString("mainClass", null);
            this.args = UpdaterResponse.readArgsList(json.get("args").asArray());
        }
    }

    public static class Updater {
        public int version;
        public CdnFile jar;
        public CdnFile exe;

        public Updater(JsonObject json) {
            this.version = json.getInt("version", UpdaterConfig.version);
            this.jar = new CdnFile(json.get("jar").asObject());
            this.exe = new CdnFile(json.get("exe").asObject());
        }
    }
}

