/*
 * Decompiled with CFR 0.152.
 */
package ru.pixelmongo.updater;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import ru.pixelmongo.updater.Main;
import ru.pixelmongo.updater.UpdaterConfig;
import ru.pixelmongo.updater.util.MD5;

public class Util {
    private static File cachedSelf;

    public static File getWorkingDirectory(String applicationName) {
        File workingDirectory;
        String userHome = System.getProperty("user.home", ".");
        switch (Util.getPlatform().ordinal()) {
            case 0: 
            case 1: {
                workingDirectory = new File(userHome, String.valueOf('.') + applicationName);
                break;
            }
            case 2: {
                String applicationData = System.getenv("APPDATA");
                if (applicationData != null) {
                    workingDirectory = new File(applicationData, "." + applicationName);
                    break;
                }
                workingDirectory = new File(userHome, String.valueOf('.') + applicationName);
                break;
            }
            case 3: {
                workingDirectory = new File(userHome, "Library/Application Support/" + applicationName);
                break;
            }
            default: {
                workingDirectory = new File(userHome, applicationName);
            }
        }
        if (!workingDirectory.exists() && !workingDirectory.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + workingDirectory);
        }
        return workingDirectory;
    }

    private static OS getPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return OS.windows;
        }
        if (osName.contains("mac")) {
            return OS.macos;
        }
        if (osName.contains("solaris")) {
            return OS.solaris;
        }
        if (osName.contains("sunos")) {
            return OS.solaris;
        }
        if (osName.contains("linux")) {
            return OS.linux;
        }
        if (osName.contains("unix")) {
            return OS.linux;
        }
        return OS.unknown;
    }

    public static void loadAllClassesFromJar() {
        try {
            Throwable var1 = null;
            try (JarFile jar = new JarFile(Util.getSelf());){
                try {
                    ClassLoader classLoader = Main.class.getClassLoader();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                        String className = entry.getName().substring(0, entry.getName().length() - 6).replace('/', '.');
                        classLoader.loadClass(className);
                    }
                }
                catch (Throwable var14) {
                    var1 = var14;
                    throw var14;
                }
            }
        }
        catch (Exception var16) {
            var16.printStackTrace();
        }
    }

    private static String byteArray2Hex(byte[] hash) {
        Formatter formatter = new Formatter();
        byte[] arrayOfByte = hash;
        int j = hash.length;
        int i = 0;
        while (i < j) {
            byte b = arrayOfByte[i];
            formatter.format("%02x", b);
            ++i;
        }
        return formatter.toString();
    }

    public static String getMd5(String FilePath) {
        try {
            File file = new File(Util.getWorkingDirectory(UpdaterConfig.launcherFolder), FilePath);
            return MD5.asHex(MD5.getHash(file));
        }
        catch (Exception exception) {
            return "0";
        }
    }

    public static File getSelf() {
        if (cachedSelf == null) {
            cachedSelf = new File(URI.create(Main.class.getProtectionDomain().getCodeSource().getLocation().toString()));
        }
        return cachedSelf;
    }

    public static String getHttpContent(String url, boolean trustAll) throws IOException {
        HttpURLConnection conn = null;
        try {
            String var5;
            String inputLine;
            block8: for (int i = 0; i < 3; ++i) {
                conn = (HttpURLConnection)new URL(url).openConnection();
                if (trustAll && conn instanceof HttpsURLConnection) {
                    TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return new X509Certificate[0];
                        }

                        @Override
                        public void checkClientTrusted(X509Certificate[] certs, String authType) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] certs, String authType) {
                        }
                    }};
                    HostnameVerifier ALL_TRUSTING_HOSTNAME_VERIFIER = new HostnameVerifier(){

                        @Override
                        public boolean verify(String hostname, SSLSession session) {
                            return true;
                        }
                    };
                    try {
                        SSLContext sc = SSLContext.getInstance("SSL");
                        sc.init(null, trustAllCerts, new SecureRandom());
                        ((HttpsURLConnection)conn).setSSLSocketFactory(sc.getSocketFactory());
                        ((HttpsURLConnection)conn).setHostnameVerifier(ALL_TRUSTING_HOSTNAME_VERIFIER);
                    }
                    catch (GeneralSecurityException e) {
                        e.printStackTrace();
                    }
                }
                conn.setConnectTimeout(48000);
                conn.setReadTimeout(48000);
                conn.setRequestProperty("Accept-Charset", "UTF-8");
                conn.setRequestProperty("User-Agent", "PixelmonGo Updater");
                conn.setRequestProperty("Cache-Control", "max-age=0");
                switch (conn.getResponseCode()) {
                    case 301: 
                    case 302: {
                        url = new URL(new URL(url), conn.getHeaderField("Location")).toExternalForm();
                        conn.disconnect();
                        continue block8;
                    }
                }
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            String string = var5 = response.toString();
            return string;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static enum OS {
        linux,
        solaris,
        windows,
        macos,
        unknown;

    }
}

